%PRADS2025.cls
%16th International Symposium on Practical Design of Ships and Other Floating Structures 
%Ann Arbor, MI, USA, October 19.-23. 2025.
% 
% Copyright 2007 Milan Vrdoljak, FSB
%
% This work may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either version 1.3
% of this license or (at your option) any later version.
% The latest version of this license is in
%   http://www.latex-project.org/lppl.txt
% and version 1.3 or later is part of all distributions of LaTeX
% version 2003/12/01 or later.
%
% This work has the LPPL maintenance status "author-maintained".
% 
% This work consists of all files listed in readme.txt.

\NeedsTeXFormat{LaTeX2e}

\DeclareOption{11pt}{\OptionNotUsed}
\DeclareOption{12pt}{\OptionNotUsed}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions

\LoadClass[a4paper,10pt]{article}
\RequirePackage{indentfirst}
\RequirePackage{xspace}

\usepackage{times}
\usepackage[left=30mm, top=34.3mm, bottom=36.3mm, right=30mm]{geometry}
%-- page dimensions
%	\addtolength{\hoffset}{-1cm}
%\setlength{\textwidth}{16cm}
%\setlength{\textheight}{23.7cm}
%\renewcommand\@pnumwidth{2.5em}
%\renewcommand\@tocrmarg{3em}
%\setlength\oddsidemargin   {63\p@}
%\setlength\evensidemargin  {63\p@}
%\setlength\marginparwidth  {90\p@}

%\setlength\headsep   {16\p@}

%\setlength\footnotesep{7.7\p@}
%\setlength\textfloatsep{8mm\@plus 2\p@ \@minus 4\p@}
%\setlength\intextsep   {8mm\@plus 2\p@ \@minus 2\p@}

%\addtolength{\oddsidemargin}{-3mm}
%\addtolength{\evensidemargin}{-5mm}
%\addtolength{\evensidemargin}{2pt}

%\renewcommand{\arraystretch}{1.2} %space between rows; default is one

%-- sections
\newcommand{\keywordname}{{\bf Key words:}}
\renewcommand{\abstractname}{Abstract.}
\renewcommand{\thesection}{\@arabic\c@section.}
\renewcommand{\thesubsection}{\thesection\@arabic\c@subsection.}
\renewcommand{\thesubsubsection}{\thesubsection\@arabic\c@subsubsection.}
\renewcommand{\thefigure}{\@arabic\c@figure.}
\renewcommand{\theequation}{\@arabic\c@equation}
\renewcommand{\thetable}{\@arabic\c@table.}
\renewcommand\section{\@startsection{section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\fontsize{14}{18}\selectfont\bfseries}}
                                   
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\bfseries}}
                                     
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {0.8ex \@plus .2ex}%
                                     {\normalfont\normalsize\itshape}}
                                     
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\normalsize\itshape}}

\renewcommand{\footnoterule}{%
  \kern-3\p@
  \hrule\@width 2cm
  \kern2.6\p@}

%-- maketitle: address, correspondence addr., multi-author addresses,
% abstract, keywords
\newcommand{\address}[1]{\gdef\@address{#1}}
\newcommand{\caddress}[1]{\renewcommand{\thefootnote}{\@fnsymbol\c@footnote}%
  \footnotetext[1]{Correspondence to: #1}%
  \renewcommand{\thefootnote}{\@arabic\c@footnote}}
\newcommand{\cauthor}{\renewcommand{\thefootnote}{\@fnsymbol\c@footnote}%
  \footnotemark[1]\xspace%
  \renewcommand{\thefootnote}{\@arabic\c@footnote}}
\newcommand{\ainstnum}[1]{${}^{#1}$\xspace}
\newcommand{\ainst}[1]{${}^{#1}$}
\newcommand{\fcomma}{$^{\rm{,}}$}

\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{myplain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
  {\Large \bfseries{\@title} \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
    {\small \@address}%
  \end{center}%
  \par
  \vskip 1.5em}

\renewenvironment{abstract}{%
      \list{}{\advance\topsep by0.35cm\relax\small
      \leftmargin=1cm
      \labelwidth=\z@
      \listparindent=\z@
      \itemindent\listparindent
      \rightmargin\leftmargin}\item[\hskip\labelsep
                                    \bfseries\abstractname]}
    {\endlist}
\newcommand{\keywords}[1]{%
	\vspace{-0.5cm}\hspace{1cm}{\small\begin{minipage}[t]{10.2cm}
		{\bfseries\keywordname\ }\itshape{#1}
	\end{minipage}}}

%-- headings
\newcommand{\cmndheads}[2]{\markboth{#1}{#2}}

\newdimen\headlineindent             % dimension for space between
\headlineindent=1.166cm              % number and text of headings.

\def\ps@myplain{\let\@mkboth\@gobbletwo
\def\@oddhead{\parbox[t]{\textwidth}{{ \textit{16th International Symposium on
\textit{Practical Design of Ships and Other Floating Structures PRADS 2025}}\hfill}\\


{\textit{Ann Arbor, MI, USA, October 19$^{\rm
th}$-23$^{\rm rd}$ 2025\hfill}}}
}
\def\@evenhead{}
\def\@oddfoot{\normalfont\small\hfill\thepage\hfill}
\def\@evenfoot{}
}

\def\ps@headings{\let\@mkboth\@gobbletwo
   \let\@oddfoot\@empty\let\@evenfoot\@empty
   \def\@evenhead{\normalfont\small\rlap{\thepage}\hspace{\headlineindent}%
   		{\itshape\leftmark}\hfil}
		\def\@oddhead{\normalfont\small\hfil{\itshape\rightmark}\hspace{\headlineindent}%
        \llap{\thepage}}
   \def\sectionmark##1{}%
   \def\subsectionmark##1{}}

\pagestyle{plain}

%-- captions
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\small{\bfseries #1} #2}%
  \ifdim \wd\@tempboxa >\hsize
  {\small{\bfseries #1} #2}\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\renewenvironment{table}
               {\setlength\abovecaptionskip{0\p@}%
                \setlength\belowcaptionskip{10\p@}%
                \@float{table}}
               {\end@float}
\renewenvironment{table*}
               {\setlength\abovecaptionskip{0\p@}%
                \setlength\belowcaptionskip{10\p@}%
                \@dblfloat{table}}
               {\end@dblfloat}


%-- bibliography
\renewenvironment{thebibliography}[1]
     {\section*{\refname}%
      \small
	  \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\endinput
